#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 DefaultParticle;
in vec4 EmissiveParticle;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * DefaultParticle * ColorModulator;
    if (color.a < 0.1) {discard;}

    float opacity = ceil(color.a * 255);
    if (opacity == 240) {color = texture(Sampler0, texCoord0) * ColorModulator;} // add "EmissiveParticle" to tint

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}